<?php
session_start();
include 'config.php';

// Tangkap parameter dari URL (jika ada)
$ref_code = $_GET['ref'] ?? '';
$placement_id = $_GET['placement_id'] ?? '';
$position = $_GET['pos'] ?? '';

// Jika ada placement_id, cari Username-nya agar user yakin
$placement_username = "Auto Placement";
if($placement_id) {
    $q = $conn->query("SELECT username FROM users WHERE id = $placement_id");
    if($r = $q->fetch_assoc()) $placement_username = $r['username'];
}
?>

<!DOCTYPE html>
<html lang="id" class="dark">
<head>
    <title>Register Member</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script>tailwind.config = { darkMode: 'class', theme: { extend: { colors: { primary: '#10b981', darkbg: '#0f172a' } } } }</script>
    <!-- FontAwesome & SweetAlert2 -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
</head>
<body class="bg-gray-100 dark:bg-darkbg text-gray-800 dark:text-gray-200 min-h-screen flex items-center justify-center p-4">

    <div class="bg-white dark:bg-slate-800 w-full max-w-md rounded-2xl shadow-2xl p-8 my-8">
        <h2 class="text-2xl font-bold mb-6 text-center text-primary">Join Network</h2>
        
        <form action="register_process.php" method="POST" class="space-y-4">
            
            <!-- Hidden Fields untuk Logika Binary -->
            <input type="hidden" name="placement_id" value="<?php echo $placement_id; ?>">
            <input type="hidden" name="position" value="<?php echo $position; ?>">

            <!-- Referral Code (Sponsor) -->
            <div>
                <label class="block text-sm font-bold mb-1 text-gray-500">Referral Code (Sponsor)</label>
                <input type="text" name="referral_code" value="<?php echo $ref_code; ?>" 
                       class="w-full p-3 rounded-lg bg-gray-50 dark:bg-slate-900 border border-gray-200 dark:border-slate-700 font-mono font-bold text-primary text-sm" 
                       placeholder="Masukkan Kode Referral, posisi anda ditentukan oleh System" <?php echo $ref_code ? 'readonly' : 'required'; ?>>
            </div>

            <!-- Info Placement (Hanya visual) -->
            <?php if($placement_id): ?>
            <div class="bg-yellow-50 dark:bg-slate-700 p-3 rounded-lg text-xs">
                <p>Anda akan ditempatkan di bawah:</p>
                <p class="font-bold text-sm"><?php echo $placement_username; ?> (Posisi: <?php echo strtoupper($position); ?>)</p>
            </div>
            <?php endif; ?>

            <div class="border-t dark:border-slate-700 my-4"></div>

            <!-- DATA PRIBADI -->
            <div>
                <label class="block text-sm font-bold mb-1 text-gray-500">Nama Lengkap</label>
                <input type="text" name="full_name" required class="w-full p-3 rounded-lg bg-gray-50 dark:bg-slate-900 border border-gray-200 dark:border-slate-700" placeholder="Nama Sesuai KTP">
            </div>

            <div>
                <label class="block text-sm font-bold mb-1 text-gray-500">Alamat Email</label>
                <input type="email" name="email" required class="w-full p-3 rounded-lg bg-gray-50 dark:bg-slate-900 border border-gray-200 dark:border-slate-700" placeholder="contoh@email.com">
            </div>

            <div>
                <label class="block text-sm font-bold mb-1 text-gray-500">Nomor HP / WhatsApp</label>
                <input type="number" name="phone" required class="w-full p-3 rounded-lg bg-gray-50 dark:bg-slate-900 border border-gray-200 dark:border-slate-700" placeholder="0812xxxx">
            </div>

            <div class="border-t dark:border-slate-700 my-4"></div>

            <!-- DATA AKUN -->
            <div>
                <label class="block text-sm font-bold mb-1 text-gray-500">Username (Login)</label>
                <input type="text" name="username" required class="w-full p-3 rounded-lg bg-gray-50 dark:bg-slate-900 border border-gray-200 dark:border-slate-700" placeholder="Buat Username Unik">
            </div>
            
            <!-- PASSWORD WITH EYE ICON -->
            <div>
                <label class="block text-sm font-bold mb-1 text-gray-500">Password</label>
                <div class="relative">
                    <input type="password" id="passwordInput" name="password" required class="w-full p-3 pr-10 rounded-lg bg-gray-50 dark:bg-slate-900 border border-gray-200 dark:border-slate-700">
                    <button type="button" onclick="togglePassword()" class="absolute inset-y-0 right-0 px-3 flex items-center text-gray-400 hover:text-primary transition">
                        <i class="fas fa-eye" id="eyeIcon"></i>
                    </button>
                </div>
            </div>

            <!-- Paket Starter (Otomatis) -->
            <div class="border-2 border-primary rounded-xl p-4 flex justify-between items-center bg-emerald-50 dark:bg-slate-900/50 mt-4">
                <div>
                    <p class="font-bold text-sm">Paket Starter</p>
                    <p class="text-xs text-gray-500">Aktifasi Member</p>
                </div>
                <span class="font-bold text-primary">Rp 300.000</span>
            </div>
            
            <button type="submit" class="w-full bg-primary hover:bg-emerald-600 text-white font-bold py-4 rounded-xl shadow-lg transition transform active:scale-95 mt-4">
                Daftar Sekarang
            </button>
        </form>
        
        <div class="mt-4 text-center">
            <a href="login.php" class="text-xs text-gray-400 hover:text-white">Sudah punya akun? Login</a>
        </div>
    </div>

    <!-- Script Toggle Password -->
    <script>
        function togglePassword() {
            const input = document.getElementById('passwordInput');
            const icon = document.getElementById('eyeIcon');
            if (input.type === "password") {
                input.type = "text";
                icon.classList.remove('fa-eye');
                icon.classList.add('fa-eye-slash');
            } else {
                input.type = "password";
                icon.classList.remove('fa-eye-slash');
                icon.classList.add('fa-eye');
            }
        }
    </script>
</body>
</html>