<?php
session_start();
include 'config.php';

if(!isset($_SESSION['user_id'])) { header("Location: login.php"); exit(); }
$user_id = $_SESSION['user_id'];
// Ambil saldo user untuk fitur 'Potong Saldo'
$user = $conn->query("SELECT balance_idr FROM users WHERE id = $user_id")->fetch_assoc();
$active_menu = 'home';
?>

<!DOCTYPE html>
<html lang="id" class="dark">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Crypto Investment</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script>tailwind.config = { darkMode: 'class', theme: { extend: { colors: { primary: '#10b981', darkbg: '#0f172a' } } } }</script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <style>
        .neon-text { text-shadow: 0 0 10px rgba(255, 165, 0, 0.7); }
    </style>
</head>
<body class="bg-slate-900 text-gray-200 transition-colors duration-300">

    <div class="max-w-md mx-auto min-h-screen relative shadow-2xl bg-slate-900 pb-24">
        
        <div class="bg-gradient-to-b from-slate-800 to-slate-900 p-6 pt-8 rounded-b-[2.5rem] shadow-lg border-b border-orange-500/20 relative">
            <div class="flex items-center">
                <a href="dashboard.php" class="bg-white/10 p-2 rounded-full hover:bg-white/20 transition"><i class="fas fa-arrow-left text-orange-500"></i></a>
                <h1 class="ml-4 font-bold text-xl text-orange-500 neon-text"><i class="fab fa-bitcoin mr-2"></i>Crypto Hub</h1>
            </div>
        </div>

        <div class="px-6 mt-6 flex justify-between gap-2 overflow-x-auto pb-2">
            <button onclick="showSection('staking')" id="btn-staking" class="flex-1 bg-orange-600 text-white py-2 px-4 rounded-xl font-bold text-xs shadow-lg shadow-orange-500/30 transition">STAKING</button>
            <button onclick="showSection('mining')" id="btn-mining" class="flex-1 bg-slate-800 text-gray-400 py-2 px-4 rounded-xl font-bold text-xs border border-slate-700 hover:border-orange-500 transition">MINING</button>
            <button onclick="showSection('earning')" id="btn-earning" class="flex-1 bg-slate-800 text-gray-400 py-2 px-4 rounded-xl font-bold text-xs border border-slate-700 hover:border-orange-500 transition">EARNING</button>
        </div>

        <div id="sec-staking" class="px-6 mt-4 space-y-4 animate-[fadeIn_0.5s]">
            <div class="bg-slate-800 rounded-2xl p-5 border border-orange-500/30 shadow-lg relative overflow-hidden">
                <div class="absolute -right-5 -top-5 text-orange-500/10 text-8xl"><i class="fas fa-layer-group"></i></div>
                <h3 class="font-bold text-lg text-white">USDT Staking</h3>
                <p class="text-xs text-gray-400 mb-4">Lock asset for high APY</p>
                <div class="grid grid-cols-2 gap-3">
                    <div onclick="openCryptoModal('Staking 30 Days', 1000000, 'staking')" class="bg-slate-900 p-3 rounded-xl border border-slate-700 hover:border-orange-500 cursor-pointer text-center">
                        <p class="text-xs text-gray-400">30 Days</p>
                        <p class="text-lg font-bold text-orange-400">5% APY</p>
                        <p class="text-[10px]">Min Rp 1 Juta</p>
                    </div>
                    <div onclick="openCryptoModal('Staking 90 Days', 5000000, 'staking')" class="bg-slate-900 p-3 rounded-xl border border-slate-700 hover:border-orange-500 cursor-pointer text-center">
                        <p class="text-xs text-gray-400">90 Days</p>
                        <p class="text-lg font-bold text-orange-400">12% APY</p>
                        <p class="text-[10px]">Min Rp 5 Juta</p>
                    </div>
                </div>
            </div>
        </div>

        <div id="sec-mining" class="px-6 mt-4 space-y-4 hidden animate-[fadeIn_0.5s]">
            <div class="bg-slate-800 rounded-2xl p-5 border border-blue-500/30 shadow-lg relative overflow-hidden">
                <div class="absolute -right-5 -top-5 text-blue-500/10 text-8xl"><i class="fas fa-microchip"></i></div>
                <h3 class="font-bold text-lg text-white">Cloud Mining</h3>
                <p class="text-xs text-gray-400 mb-4">Rent hash power</p>
                <div class="space-y-3">
                    <div onclick="openCryptoModal('Mining Starter (10 TH/s)', 2000000, 'mining')" class="bg-slate-900 p-4 rounded-xl border border-slate-700 hover:border-blue-500 cursor-pointer flex justify-between items-center">
                        <div>
                            <p class="font-bold text-white">Starter Rig</p>
                            <p class="text-xs text-blue-400">10 TH/s</p>
                        </div>
                        <span class="text-sm font-bold">Rp 2.000.000</span>
                    </div>
                    <div onclick="openCryptoModal('Mining Pro (50 TH/s)', 10000000, 'mining')" class="bg-slate-900 p-4 rounded-xl border border-slate-700 hover:border-blue-500 cursor-pointer flex justify-between items-center">
                        <div>
                            <p class="font-bold text-white">Pro Rig</p>
                            <p class="text-xs text-blue-400">50 TH/s</p>
                        </div>
                        <span class="text-sm font-bold">Rp 10.000.000</span>
                    </div>
                </div>
            </div>
        </div>

        <div id="sec-earning" class="px-6 mt-4 space-y-4 hidden animate-[fadeIn_0.5s]">
             <div class="bg-slate-800 rounded-2xl p-5 border border-green-500/30 shadow-lg relative overflow-hidden">
                <div class="absolute -right-5 -top-5 text-green-500/10 text-8xl"><i class="fas fa-hand-holding-usd"></i></div>
                <h3 class="font-bold text-lg text-white">Simple Earn</h3>
                <p class="text-xs text-gray-400 mb-4">Flexible savings</p>
                 <div onclick="openCryptoModal('Flexi Earn USDT', 500000, 'earning')" class="bg-slate-900 p-4 rounded-xl border border-slate-700 hover:border-green-500 cursor-pointer flex justify-between items-center">
                    <div>
                        <p class="font-bold text-white">Flexi USDT</p>
                        <p class="text-xs text-green-400">Est. 3% Yield</p>
                    </div>
                    <span class="text-sm font-bold">Min Rp 500rb</span>
                </div>
            </div>
        </div>

        <div id="buyModal" class="fixed inset-0 bg-black/90 hidden z-[60] flex items-end sm:items-center justify-center px-4 backdrop-blur-sm">
            <div class="bg-slate-800 w-full max-w-sm rounded-t-3xl sm:rounded-3xl p-6 relative border border-slate-700 animate-[slideUp_0.3s_ease-out]">
                <button onclick="closeModal()" class="absolute top-4 right-4 text-gray-400 hover:text-red-500"><i class="fas fa-times text-xl"></i></button>
                
                <h3 class="font-bold text-xl text-white mb-1">Confirm Transaction</h3>
                <p id="modalPkgName" class="text-orange-500 font-bold mb-4">Package Name</p>
                
                <form action="process.php" method="POST" enctype="multipart/form-data" class="space-y-4">
                    <input type="hidden" name="action" value="buy_crypto">
                    <input type="hidden" name="package_name" id="inputPkgName">
                    <input type="hidden" name="amount" id="inputAmount">
                    <input type="hidden" name="category" id="inputCategory">

                    <div class="bg-slate-900 p-4 rounded-xl border border-slate-700">
                        <p class="text-xs text-gray-400">Total Price</p>
                        <p id="modalPrice" class="text-xl font-bold text-white">Rp 0</p>
                    </div>

                    <div>
                        <label class="block text-xs font-bold text-gray-400 mb-2">Payment Method</label>
                        <div class="grid grid-cols-2 gap-3">
                            <label class="cursor-pointer">
                                <input type="radio" name="payment_method" value="Potong Saldo" class="peer hidden" checked onchange="toggleProof(false)">
                                <div class="bg-slate-900 p-3 rounded-xl border border-slate-700 peer-checked:border-orange-500 peer-checked:text-orange-500 text-center transition">
                                    <i class="fas fa-wallet mb-1 block"></i> Potong Saldo
                                    <p class="text-[9px] text-gray-500">Bal: Rp <?php echo number_format($user['balance_idr']/1000); ?>k</p>
                                </div>
                            </label>
                            <label class="cursor-pointer">
                                <input type="radio" name="payment_method" value="Transfer Crypto" class="peer hidden" onchange="toggleProof(true)">
                                <div class="bg-slate-900 p-3 rounded-xl border border-slate-700 peer-checked:border-orange-500 peer-checked:text-orange-500 text-center transition">
                                    <i class="fas fa-qrcode mb-1 block"></i> TRC20 / QR
                                    <p class="text-[9px] text-gray-500">External Transfer</p>
                                </div>
                            </label>
                        </div>
                    </div>

                    <div id="proofSection" class="hidden">
                        <label class="block text-xs font-bold text-gray-500 mb-1">Upload Bukti Transfer</label>
                        <input type="file" name="proof" class="w-full text-xs bg-slate-900 border border-slate-700 rounded-xl p-2 text-gray-400">
                    </div>

                    <button type="submit" class="w-full bg-orange-600 hover:bg-orange-700 text-white font-bold py-3 rounded-xl shadow-lg mt-2">
                        Process Now
                    </button>
                </form>
            </div>
        </div>

        <?php include 'footer_nav.php'; ?>
    </div>

    <script>
        function showSection(sec) {
            ['staking', 'mining', 'earning'].forEach(id => {
                document.getElementById('sec-'+id).classList.add('hidden');
                document.getElementById('btn-'+id).classList.remove('bg-orange-600', 'text-white', 'shadow-lg');
                document.getElementById('btn-'+id).classList.add('bg-slate-800', 'text-gray-400', 'border-slate-700');
            });
            document.getElementById('sec-'+sec).classList.remove('hidden');
            const btn = document.getElementById('btn-'+sec);
            btn.classList.remove('bg-slate-800', 'text-gray-400', 'border-slate-700');
            btn.classList.add('bg-orange-600', 'text-white', 'shadow-lg');
        }

        function openCryptoModal(name, price, cat) {
            document.getElementById('modalPkgName').innerText = name;
            document.getElementById('inputPkgName').value = name;
            document.getElementById('inputAmount').value = price;
            document.getElementById('inputCategory').value = cat;
            document.getElementById('modalPrice').innerText = 'Rp ' + parseInt(price).toLocaleString();
            document.getElementById('buyModal').classList.remove('hidden');
        }

        function toggleProof(show) {
            const el = document.getElementById('proofSection');
            if(show) el.classList.remove('hidden');
            else el.classList.add('hidden');
        }

        function closeModal() {
            document.getElementById('buyModal').classList.add('hidden');
        }
    </script>
</body>
</html>