<?php
session_start();
include 'config.php';

if(!isset($_SESSION['user_id'])) { header("Location: login.php"); exit(); }
$user_id = $_SESSION['user_id'];
$active_menu = 'home'; 

$paket_crowd = [
    ['price' => 10000000, 'name' => 'Standar (1 Kolam)', 'color' => 'bg-purple-500'],
    ['price' => 30000000, 'name' => 'Medium (3 Kolam)', 'color' => 'bg-purple-600'],
    ['price' => 60000000, 'name' => 'Large (6 Kolam)', 'color' => 'bg-purple-700']
];
?>

<!DOCTYPE html>
<html lang="id" class="dark">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Crowdfunding</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script>tailwind.config = { darkMode: 'class', theme: { extend: { colors: { primary: '#10b981', darkbg: '#0f172a' } } } }</script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
</head>
<body class="bg-gray-100 dark:bg-darkbg text-gray-800 dark:text-gray-200 transition-colors duration-300">

    <div class="max-w-md mx-auto min-h-screen relative shadow-2xl bg-white dark:bg-slate-900 pb-24">
        
        <div class="bg-purple-600 p-6 pt-8 rounded-b-[2.5rem] shadow-lg text-white relative">
            <div class="flex items-center">
                <a href="dashboard.php" class="bg-white/20 p-2 rounded-full hover:bg-white/30 transition"><i class="fas fa-arrow-left"></i></a>
                <h1 class="ml-4 font-bold text-xl">Crowdfunding</h1>
            </div>
            <p class="mt-4 text-purple-100 text-sm text-center">Investasi kolam bersama. Profit sharing 10% per bulan.</p>
        </div>

        <div class="px-6 mt-6 space-y-5">
            
            <?php foreach($paket_crowd as $pkg): ?>
            <div class="bg-white dark:bg-slate-800 rounded-2xl p-5 shadow-md border border-gray-100 dark:border-slate-700 flex justify-between items-center group hover:border-purple-400 transition">
                <div>
                    <span class="text-[10px] font-bold text-purple-500 uppercase tracking-wide">Fixed Plan</span>
                    <h3 class="font-bold text-lg mb-1"><?php echo $pkg['name']; ?></h3>
                    <h2 class="text-xl font-bold text-gray-800 dark:text-white">Rp <?php echo number_format($pkg['price']); ?></h2>
                    <p class="text-xs text-green-500 mt-1"><i class="fas fa-chart-line"></i> Profit 10%/bln</p>
                </div>
                <button onclick="openCrowdModal('<?php echo $pkg['name']; ?>', <?php echo $pkg['price']; ?>)" class="bg-purple-600 text-white w-10 h-10 rounded-full flex items-center justify-center shadow-lg active:scale-95 transition">
                    <i class="fas fa-arrow-right"></i>
                </button>
            </div>
            <?php endforeach; ?>

            <div class="bg-gradient-to-r from-purple-800 to-indigo-900 rounded-2xl p-6 shadow-lg text-white relative overflow-hidden">
                <div class="absolute -right-5 -top-5 text-white/10 text-6xl"><i class="fas fa-sliders-h"></i></div>
                <h3 class="font-bold text-lg mb-2 relative z-10">Paket Custom</h3>
                <p class="text-xs text-purple-200 mb-4 relative z-10">Tentukan jumlah kolam sendiri. (1 Kolam = Rp 10 Juta)</p>
                
                <div class="relative z-10">
                    <label class="text-xs font-bold uppercase mb-1 block">Masukkan Nominal</label>
                    <input type="number" id="customAmount" class="w-full rounded-xl p-3 text-black font-bold mb-2" placeholder="Kelipatan 10.000.000" oninput="calcCustom()">
                    <p class="text-xs text-yellow-300 mb-3" id="customCalc">Total: 0 Kolam</p>
                    <button onclick="processCustom()" class="w-full bg-white text-purple-800 font-bold py-3 rounded-xl shadow hover:bg-gray-100 transition">Lanjut Custom</button>
                </div>
            </div>

        </div>

        <div id="buyModal" class="fixed inset-0 bg-black/80 hidden z-[60] flex items-end sm:items-center justify-center px-4 backdrop-blur-sm">
            <div class="bg-white dark:bg-slate-800 w-full max-w-sm rounded-t-3xl sm:rounded-3xl p-6 relative animate-[slideUp_0.3s_ease-out]">
                <button onclick="closeModal()" class="absolute top-4 right-4 text-gray-400 hover:text-red-500"><i class="fas fa-times text-xl"></i></button>
                
                <h3 class="font-bold text-xl mb-1">Join Crowdfunding</h3>
                <p id="modalPkgName" class="text-purple-600 font-bold mb-4">Nama Paket</p>
                
                <form action="process.php" method="POST" enctype="multipart/form-data" class="space-y-4">
                    <input type="hidden" name="action" value="buy_crowd">
                    <input type="hidden" name="package_name" id="inputPkgName">
                    <input type="hidden" name="amount" id="inputAmount">

                    <div>
                        <label class="block text-xs font-bold text-gray-500 mb-1">Durasi Kontrak</label>
                        <select name="duration" class="w-full bg-gray-50 dark:bg-slate-900 border border-gray-200 dark:border-slate-700 rounded-xl p-3 text-sm font-bold">
                            <option value="3">3 Bulan</option>
                            <option value="6">6 Bulan</option>
                            <option value="12">12 Bulan</option>
                        </select>
                    </div>

                    <div>
                        <label class="block text-xs font-bold text-gray-500 mb-1">Metode Pembayaran</label>
                        <select name="payment_method" class="w-full bg-gray-50 dark:bg-slate-900 border border-gray-200 dark:border-slate-700 rounded-xl p-3 text-sm font-bold">
                            <option value="Transfer Bank BCA">Transfer Bank BCA</option>
                            <option value="USDT">Crypto USDT (TRC20)</option>
                        </select>
                    </div>

                    <div>
                        <label class="block text-xs font-bold text-gray-500 mb-1">Bukti Transfer</label>
                        <input type="file" name="proof" required class="w-full text-xs bg-gray-50 dark:bg-slate-900 border border-gray-200 dark:border-slate-700 rounded-xl p-2">
                    </div>

                    <div class="bg-purple-50 dark:bg-slate-700/50 p-3 rounded-lg text-xs text-center">
                        Total Tagihan: <br>
                        <span id="modalPrice" class="text-lg font-bold text-purple-600">Rp 0</span>
                    </div>

                    <button type="submit" class="w-full bg-purple-600 hover:bg-purple-700 text-white font-bold py-3 rounded-xl shadow-lg mt-2">
                        Bayar Sekarang
                    </button>
                </form>
            </div>
        </div>

        <?php include 'footer_nav.php'; ?>
    </div>

    <script>
        function calcCustom() {
            const val = document.getElementById('customAmount').value;
            const pools = val / 10000000;
            document.getElementById('customCalc').innerText = `Estimasi: ${pools} Kolam`;
        }

        function processCustom() {
            const val = document.getElementById('customAmount').value;
            if(val < 10000000 || val % 10000000 !== 0) {
                Swal.fire('Error', 'Minimal Rp 10 Juta dan Kelipatan 10 Juta', 'error');
                return;
            }
            openCrowdModal(`Custom (${val/10000000} Kolam)`, val);
        }

        function openCrowdModal(name, price) {
            document.getElementById('modalPkgName').innerText = name;
            document.getElementById('inputPkgName').value = name;
            document.getElementById('inputAmount').value = price;
            document.getElementById('modalPrice').innerText = 'Rp ' + parseInt(price).toLocaleString();
            document.getElementById('buyModal').classList.remove('hidden');
        }

        function closeModal() {
            document.getElementById('buyModal').classList.add('hidden');
        }
    </script>
</body>
</html>