<?php
session_start();
include '../config.php';

// Cek Login
if (!isset($_SESSION['admin_logged_in'])) { header("Location: login.php"); exit(); }

// ERROR FIX: Hapus function formatRupiah() disini karena sudah ada di config.php

// Handle Input Manual Aset
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['add_asset'])) {
    $type = $_POST['project_type'];
    $name = $_POST['asset_name'];
    $val = $_POST['value'];
    $conn->query("INSERT INTO project_assets (project_type, asset_name, value) VALUES ('$type', '$name', '$val')");
    header("Location: project.php"); exit();
}

$page_role = $_SESSION['admin_role']; // super_admin, secretary, branch
?>
<!DOCTYPE html>
<html lang="id" class="dark">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pengelolaan Asset Project</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script>tailwind.config = { darkMode: 'class', theme: { extend: { colors: { primary: '#10b981', darkbg: '#0f172a' } } } }</script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
</head>
<body class="bg-gray-100 dark:bg-darkbg text-gray-800 dark:text-gray-200 font-sans min-h-screen p-6">

    <div class="max-w-7xl mx-auto">
        <div class="flex justify-between items-center mb-8 bg-slate-800 p-4 rounded-2xl text-white shadow-lg">
            <div>
                <h1 class="text-2xl font-bold"><i class="fas fa-chart-pie mr-2"></i>Pengelolaan Asset</h1>
                <p class="text-sm opacity-80">Halo, <?php echo $_SESSION['admin_name'] ?? 'Admin'; ?> (<?php echo ucfirst($page_role); ?>)</p>
            </div>
            <div class="flex gap-3">
                <a href="index.php" class="bg-gray-600 hover:bg-gray-500 px-4 py-2 rounded-lg text-sm font-bold">Kembali ke Dashboard</a>
                <a href="../logout.php" class="bg-red-500 hover:bg-red-600 px-4 py-2 rounded-lg text-sm font-bold">Logout</a>
            </div>
        </div>

        <!-- FORM TAMBAH ASET -->
        <div class="bg-white dark:bg-slate-800 p-6 rounded-2xl shadow-sm border border-gray-200 dark:border-slate-700 mb-8">
            <h3 class="font-bold text-lg mb-4">Input Aset Baru</h3>
            <form method="POST" class="flex flex-col md:flex-row gap-4">
                <input type="hidden" name="add_asset" value="1">
                <select name="project_type" class="p-3 rounded-lg bg-gray-50 dark:bg-slate-900 border border-slate-600" required>
                    <option value="stokis">Project STOKIS</option>
                    <option value="crowd">Project CROWD</option>
                    <option value="crypto">Project CRYPTO</option>
                </select>
                <input type="text" name="asset_name" placeholder="Nama Aset / Item" class="flex-1 p-3 rounded-lg bg-gray-50 dark:bg-slate-900 border border-slate-600" required>
                <input type="number" name="value" placeholder="Nilai Aset (IDR)" class="w-full md:w-48 p-3 rounded-lg bg-gray-50 dark:bg-slate-900 border border-slate-600" required>
                <button type="submit" class="bg-primary hover:bg-emerald-600 text-white font-bold px-6 py-3 rounded-lg shadow-lg">Simpan</button>
            </form>
        </div>

        <!-- DAFTAR ASET -->
        <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
            <!-- STOKIS -->
            <div class="bg-white dark:bg-slate-800 rounded-2xl shadow-sm border border-blue-200 dark:border-blue-900 p-4">
                <h3 class="font-bold text-blue-500 text-lg border-b pb-2 mb-2"><i class="fas fa-cubes mr-2"></i>Aset Stokis</h3>
                <?php 
                $q = $conn->query("SELECT * FROM project_assets WHERE project_type='stokis' ORDER BY id DESC");
                while($row = $q->fetch_assoc()): ?>
                <div class="flex justify-between items-center py-2 border-b dark:border-slate-700">
                    <span class="text-sm"><?php echo $row['asset_name']; ?></span>
                    <span class="font-bold text-sm"><?php echo formatRupiah($row['value']); ?></span>
                </div>
                <?php endwhile; ?>
            </div>

            <!-- CROWD -->
            <div class="bg-white dark:bg-slate-800 rounded-2xl shadow-sm border border-purple-200 dark:border-purple-900 p-4">
                <h3 class="font-bold text-purple-500 text-lg border-b pb-2 mb-2"><i class="fas fa-users mr-2"></i>Aset Crowd</h3>
                <?php 
                $q = $conn->query("SELECT * FROM project_assets WHERE project_type='crowd' ORDER BY id DESC");
                while($row = $q->fetch_assoc()): ?>
                <div class="flex justify-between items-center py-2 border-b dark:border-slate-700">
                    <span class="text-sm"><?php echo $row['asset_name']; ?></span>
                    <span class="font-bold text-sm"><?php echo formatRupiah($row['value']); ?></span>
                </div>
                <?php endwhile; ?>
            </div>

            <!-- CRYPTO -->
            <div class="bg-white dark:bg-slate-800 rounded-2xl shadow-sm border border-orange-200 dark:border-orange-900 p-4">
                <h3 class="font-bold text-orange-500 text-lg border-b pb-2 mb-2"><i class="fab fa-bitcoin mr-2"></i>Aset Crypto</h3>
                <?php 
                $q = $conn->query("SELECT * FROM project_assets WHERE project_type='crypto' ORDER BY id DESC");
                while($row = $q->fetch_assoc()): ?>
                <div class="flex justify-between items-center py-2 border-b dark:border-slate-700">
                    <span class="text-sm"><?php echo $row['asset_name']; ?></span>
                    <span class="font-bold text-sm"><?php echo formatRupiah($row['value']); ?></span>
                </div>
                <?php endwhile; ?>
            </div>
        </div>

    </div>
</body>
</html>